/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingUniversity;
import com.minecolonies.coremod.colony.jobs.JobResearch;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkResearcher
extends AbstractEntityAIInteract<JobResearch, BuildingUniversity> {
    public static final int STUDY_DELAY = 1200;
    private static final double XP_PER_STUDYPOS = 2.0;
    private BlockPos studyPos = null;

    public EntityAIWorkResearcher(@NotNull JobResearch job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.STUDY, this::study, 1200));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingUniversity> getExpectedBuildingClass() {
        return BuildingUniversity.class;
    }

    private IAIState study() {
        IColony colony = ((BuildingUniversity)this.building).getColony();
        List<ILocalResearch> inProgress = colony.getResearchManager().getResearchTree().getResearchInProgress();
        if (!inProgress.isEmpty() && ((JobResearch)this.job).getCurrentMana() > 0) {
            ILocalResearch research = inProgress.get(this.worker.m_21187_().nextInt(inProgress.size()));
            if (colony.getResearchManager().getResearchTree().getResearch(research.getBranch(), research.getId()).research(colony.getResearchManager().getResearchEffects(), colony.getResearchManager().getResearchTree())) {
                ((BuildingUniversity)this.building).onSuccess(research);
            }
            ((JobResearch)this.job).reduceCurrentMana();
        }
        if (this.studyPos == null) {
            this.studyPos = ((BuildingUniversity)this.building).getRandomBookShelf();
        }
        if (this.walkToBlock(this.studyPos)) {
            return this.getState();
        }
        this.worker.decreaseSaturationForContinuousAction();
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.studyPos = null;
        this.worker.queueSound(SoundEvents.f_11713_, this.worker.m_142538_().m_7494_(), 80, 15, 0.25f, 1.5f);
        return AIWorkerState.START_WORKING;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        if (this.studyPos == null) {
            this.studyPos = ((BuildingUniversity)this.building).getRandomBookShelf();
        }
        return AIWorkerState.STUDY;
    }
}

